/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.client.model.block.IncrementalFluidCuboid;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankModel
implements IModelGeometry<TankModel> {
    private static final Logger log = LogManager.getLogger(TankModel.class);
    protected static final ResourceLocation BAKE_LOCATION = TConstruct.getResource("dynamic_model_baking");
    public static final Loader LOADER = new Loader();
    protected final SimpleBlockModel model;
    @Nullable
    protected final SimpleBlockModel gui;
    protected final IncrementalFluidCuboid fluid;
    protected final boolean forceModelFluid;

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>(this.model.getTextures(owner, modelGetter, missingTextureErrors));
        if (this.gui != null) {
            textures.addAll(this.gui.getTextures(owner, modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked;
        BakedModel bakedGui = baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        if (this.gui != null) {
            bakedGui = this.gui.bakeModel(owner, transform, overrides, spriteGetter, location);
        }
        return new Baked<TankModel>(owner, transform, baked, bakedGui, this);
    }

    public TankModel(SimpleBlockModel model, @Nullable SimpleBlockModel gui, IncrementalFluidCuboid fluid, boolean forceModelFluid) {
        this.model = model;
        this.gui = gui;
        this.fluid = fluid;
        this.forceModelFluid = forceModelFluid;
    }

    public static class Baked<T extends TankModel>
    extends BakedGuiUniqueModel {
        private final IModelConfiguration owner;
        private final ModelState originalTransforms;
        protected final T original;
        private final Cache<FluidStack, BakedModel> cache = CacheBuilder.newBuilder().maximumSize(64L).build();

        protected Baked(IModelConfiguration owner, ModelState transforms, BakedModel baked, BakedModel gui, T original) {
            super(baked, gui);
            this.owner = owner;
            this.originalTransforms = transforms;
            this.original = original;
        }

        public ItemOverrides m_7343_() {
            return FluidPartOverride.INSTANCE;
        }

        private BakedModel bakeWithFluid(IModelConfiguration owner, SimpleBlockModel baseModel, BlockElement fluid, int color, int luminosity) {
            Function spriteGetter = ForgeModelBakery.defaultTextureGetter();
            TextureAtlasSprite particle = (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture("particle"));
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(owner, ItemOverrides.f_111734_).m_119528_(particle);
            for (BlockElement element : baseModel.getElements()) {
                SimpleBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IModelConfiguration)owner, (BlockElement)element, (ModelState)this.originalTransforms, (Function)spriteGetter, (ResourceLocation)BAKE_LOCATION);
            }
            ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IModelConfiguration)owner, (BlockElement)fluid, (int)color, (int)luminosity, (ModelState)this.originalTransforms, (Function)spriteGetter, (ResourceLocation)BAKE_LOCATION);
            return builder.m_119533_();
        }

        private BakedModel getModel(FluidStack stack) {
            FluidAttributes attributes = stack.getFluid().getAttributes();
            int color = attributes.getColor(stack);
            int luminosity = attributes.getLuminosity(stack);
            ImmutableMap textures = ImmutableMap.of((Object)"fluid", (Object)ModelLoaderRegistry.blockMaterial((ResourceLocation)attributes.getStillTexture(stack)), (Object)"flowing_fluid", (Object)ModelLoaderRegistry.blockMaterial((ResourceLocation)attributes.getFlowingTexture(stack)));
            ExtraTextureConfiguration textured = new ExtraTextureConfiguration(this.owner, (Map)textures);
            BlockElement fluid = ((TankModel)this.original).fluid.getPart(stack.getAmount(), attributes.isGaseous(stack));
            Object baked = this.bakeWithFluid((IModelConfiguration)textured, ((TankModel)this.original).model, fluid, color, luminosity);
            if (((TankModel)this.original).gui != null) {
                baked = new BakedGuiUniqueModel((BakedModel)baked, this.bakeWithFluid((IModelConfiguration)textured, ((TankModel)this.original).gui, fluid, color, 0));
            }
            return baked;
        }

        private BakedModel getCachedModel(FluidStack fluid) {
            try {
                return (BakedModel)this.cache.get((Object)fluid, () -> this.getModel(fluid));
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                return this;
            }
        }

        private BakedModel getCachedModel(FluidStack fluid, int capacity) {
            int increments = ((TankModel)this.original).fluid.getIncrements();
            return this.getCachedModel(new FluidStack(fluid, Mth.m_14045_((int)(fluid.getAmount() * increments / capacity), (int)1, (int)increments)));
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
            IFluidTank tank;
            if ((((TankModel)this.original).forceModelFluid || ((Boolean)Config.CLIENT.tankFluidModel.get()).booleanValue()) && data.hasProperty(ModelProperties.FLUID_TANK) && (tank = (IFluidTank)data.getData(ModelProperties.FLUID_TANK)) != null && !tank.getFluid().isEmpty()) {
                return this.getCachedModel(tank.getFluid(), tank.getCapacity()).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
            }
            return this.originalModel.getQuads(state, side, rand, data);
        }

        public IncrementalFluidCuboid getFluid() {
            return ((TankModel)this.original).fluid;
        }
    }

    public static class Loader
    implements IModelLoader<TankModel> {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public TankModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
            SimpleBlockModel gui = null;
            if (modelContents.has("gui")) {
                gui = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)GsonHelper.m_13930_((JsonObject)modelContents, (String)"gui"));
            }
            IncrementalFluidCuboid fluid = IncrementalFluidCuboid.fromJson(GsonHelper.m_13930_((JsonObject)modelContents, (String)"fluid"));
            boolean forceModelFluid = GsonHelper.m_13855_((JsonObject)modelContents, (String)"render_fluid_in_model", (boolean)false);
            return new TankModel(model, gui, fluid, forceModelFluid);
        }
    }

    private static class BakedGuiUniqueModel
    extends BakedModelWrapper<BakedModel> {
        private final BakedModel gui;

        public BakedGuiUniqueModel(BakedModel base, BakedModel gui) {
            super(base);
            this.gui = gui;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
            if (cameraTransformType == ItemTransforms.TransformType.GUI) {
                return this.gui.handlePerspective(cameraTransformType, mat);
            }
            return this.originalModel.handlePerspective(cameraTransformType, mat);
        }
    }

    private static class FluidPartOverride
    extends ItemOverrides {
        public static final FluidPartOverride INSTANCE = new FluidPartOverride();

        private FluidPartOverride() {
        }

        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (stack.m_41619_() || !stack.m_41782_()) {
                return model;
            }
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.isEmpty()) {
                return model;
            }
            return ((Baked)model).getCachedModel(tank.getFluid(), tank.getCapacity());
        }
    }
}

